import pygame
""" Funções utilitárias de imagens """

def carregar_imagem(caminho: str, altura_escala: int | None = None) -> pygame.Surface:
    """
    Carrega uma imagem mantendo proporção. Se altura_escala for informada,
    a imagem será redimensionada para essa altura mantendo a proporção.
    """
    imagem = pygame.image.load(caminho).convert_alpha()
    if altura_escala is None:
        return imagem
    largura_atual, altura_atual = imagem.get_size()
    proporcao = altura_escala / altura_atual
    novo_tamanho = (int(largura_atual * proporcao), int(altura_atual * proporcao))
    return pygame.transform.smoothscale(imagem, novo_tamanho)


