import os
import pygame
from util_imagem import carregar_imagem
""" Construção de cenário: chão, tijolos, canos e decorações """
def construir_cenario(dir_arquivos: str, altura_janela: int, comprimento_nivel: int) -> tuple[list[pygame.Rect], list[tuple[pygame.Surface, pygame.Rect]]]:
    solidos: list[pygame.Rect] = []
    decoracoes: list[tuple[pygame.Surface, pygame.Rect]] = []
    chao = pygame.Rect(0, altura_janela - 64, comprimento_nivel, 64)
    solidos.append(chao)
    caminho_tijolo = os.path.join(dir_arquivos, "tijolo.jpeg")
    img_tijolo = carregar_imagem(caminho_tijolo, altura_escala=48)
    plataformas_tijolo = [
        (300, altura_janela - 200, 5),
        (900, altura_janela - 260, 4),
        (1400, altura_janela - 180, 6),
        (2100, altura_janela - 230, 5),
        (2600, altura_janela - 160, 8),
        (3400, altura_janela - 220, 6),
        (4100, altura_janela - 190, 7),
        (4800, altura_janela - 250, 6),
    ]
    for inicio_x, y, blocos in plataformas_tijolo:
        for i in range(blocos):
            ret = pygame.Rect(inicio_x + i * 64, y, 64, 48)
            solidos.append(ret)
            ret_sprite = img_tijolo.get_rect()
            ret_sprite.topleft = (ret.x, ret.y)
            decoracoes.append((img_tijolo, ret_sprite))
    caminho_cano = os.path.join(dir_arquivos, "cano1.png")
    img_cano = carregar_imagem(caminho_cano, altura_escala=96)
    posicoes_canos = [800, 1200, 1750, 2250, 2950, 3600, 4300, 5050, 5600]
    for px in posicoes_canos:
        ret_cano = img_cano.get_rect()
        ret_cano.bottomleft = (px, altura_janela - 64)
        solidos.append(pygame.Rect(ret_cano.x, ret_cano.y, ret_cano.width, ret_cano.height))
        decoracoes.append((img_cano, ret_cano))
    return solidos, decoracoes