import pygame
"""carrega as imagens"""
def carregar_imagem(caminho: str, altura_escala: int | None=None) -> pygame.surface:
    """calcula proporçao"""
    imagem = pygame.image.load(caminho).convert_alpha()
    if altura_escala is None:
        return imagem
    largura_atual, altura_atual = imagem.get_size()
    proporçao = altura_escala / altura_atual
    novo_tamanho = (int(largura_atual * proporçao), int(altura_atual * proporçao))
    return pygame.transform.smoothscale(imagem, novo_tamanho)