import pygame
from config import LARGURA_JANELA, ALTURA_JANELA
from placar import formatar_ms, top5


""" Desenho de HUD, telas e botões """


def desenhar_grade(superficie: pygame.Surface, deslocamento_x: int, comprimento_nivel: int, altura_janela: int
    cor = (220, 220, 220)
    for x in range(0, comprimento_nivel + 64, 64):
        tela_x = x - deslocamento_x
        pygame.draw.line(superficie, cor, (tela_x, 0), (tela_x, altura_janela))


def botao_reiniciar_topo(tela: pygame.Surface) -> pygame.Rect:
    btn = pygame.Rect(LARGURA_JANELA - 180, 10, 170, 36)
    pygame.draw.rect(tela, (0, 0, 0), btn, 2)
    texto_btn = pygame.font.SysFont(None, 24).render("REINICIAR (R)", True, (0, 0, 0))
    tela.blit(texto_btn, texto_btn.get_rect(center=btn.center))
    return btn


def tela_inicio(tela: pygame.Surface, registros: list[tuple[int, str]]):
    fonte = pygame.font.SysFont(None, 24)
    titulo = pygame.font.SysFont(None, 64).render("MARIO - SIMPLES", True, (0, 0, 0))
    ret_titulo = titulo.get_rect(center=(LARGURA_JANELA // 2, 100))
    tela.blit(titulo, ret_titulo)
    lista = top5(registros)
    y = 170
    tela.blit(fonte.render("TOP 5 TEMPOS (s.ms):", True, (0, 0, 0)), (LARGURA_JANELA // 2 - 140, y))
    y += 28
    if not lista:
        tela.blit(fonte.render("Sem tempos salvos.", True, (0, 0, 0)), (LARGURA_JANELA // 2 - 100, y))
    else:
        for i, (ms, nome) in enumerate(lista, start=1):
            linha = f"{i}. {formatar_ms(ms)} - {nome}"
            tela.blit(fonte.render(linha, True, (0, 0, 0)), (LARGURA_JANELA // 2 - 160, y))
            y += 24
    instru = fonte.render("Pressione qualquer tecla para começar", True, (0, 0, 0))
    ret_instr = instru.get_rect(center=(LARGURA_JANELA // 2, ALTURA_JANELA - 60))
    tela.blit(instru, ret_instr)


def hud_tempo(tela: pygame.Surface, tempo_ms: int):
    fonte = pygame.font.SysFont(None, 24)
    texto = fonte.render(f"Tempo: {formatar_ms(tempo_ms)}", True, (0, 0, 0))
    tela.blit(texto, (16, 10))


def tela_final(tela: pygame.Surface, tempo_final_ms: int, nome_atual: str) -> pygame.Rect:
    sobreposicao = pygame.Surface((LARGURA_JANELA, ALTURA_JANELA), pygame.SRCALPHA)
    sobreposicao.fill((0, 0, 0, 120))
    tela.blit(sobreposicao, (0, 0))
    fonte_grande = pygame.font.SysFont(None, 72)
    mensagem = fonte_grande.render(f"FIM DO JOGO - {formatar_ms(tempo_final_ms)}", True, (255, 255, 255))
    ret_mensagem = mensagem.get_rect(center=(LARGURA_JANELA // 2, ALTURA_JANELA // 2 - 40))
    tela.blit(mensagem, ret_mensagem)
    fonte = pygame.font.SysFont(None, 24)
    instru_nome = fonte.render("Digite seu nome e pressione Enter:", True, (255, 255, 255))
    tela.blit(instru_nome, (LARGURA_JANELA // 2 - 160, ALTURA_JANELA // 2 + 10))
    caixa_ret = pygame.Rect(LARGURA_JANELA // 2 - 160, ALTURA_JANELA // 2 + 36, 320, 30)
    pygame.draw.rect(tela, (255, 255, 255), caixa_ret, 2)
    texto_nome = fonte.render(nome_atual, True, (255, 255, 255))
    tela.blit(texto_nome, (caixa_ret.x + 8, caixa_ret.y + 5))
    btn_larg, btn_alt = 240, 56
    btn_ret = pygame.Rect((LARGURA_JANELA - btn_larg) // 2, ALTURA_JANELA // 2 + 80, btn_larg, btn_alt)
    pygame.draw.rect(tela, (255, 255, 255), btn_ret, 2)
    btn_txt = pygame.font.SysFont(None, 36).render("REINICIAR (R)", True, (255, 255, 255))
    tela.blit(btn_txt, btn_txt.get_rect(center=btn_ret.center))
    return btn_ret

